// Autor: Ivan Katanic

#include <algorithm>
#include <cassert>
#include <cstring>
#include <iostream>
#include <queue>
#include <cstdio>

using namespace std;

const int MAXN = 1010;
const int MAXD = MAXN * MAXN;

char a[MAXN][MAXN];
int ds[MAXN][MAXN];
int dt[MAXN][MAXN];
int cnt[MAXD];
int n, m, q;

int dx[] = {+1, 0, -1, 0};
int dy[] = {0, -1, 0, +1};

void bfs(int startx, int starty, int d[MAXN][MAXN]) {
  for (int i = 0; i < n; ++i)
    for (int j = 0; j < m; ++j)
      d[i][j] = -1;
  
  queue<int> Q;
  Q.push(startx); Q.push(starty);
  d[startx][starty] = 0;

  while (!Q.empty()) {
    int x = Q.front(); Q.pop();
    int y = Q.front(); Q.pop();

    for (int k = 0; k < 4; ++k) {
      int nx = x + dx[k], ny = y + dy[k];
      if (nx < 0 || nx >= n || ny < 0 || ny >= m || a[nx][ny] == '#') continue;
      if (d[nx][ny] == -1) {
        d[nx][ny] = d[x][y] + 1;
        Q.push(nx); Q.push(ny);
      }
    }
  }
}

int main(void) {
  scanf("%d %d %d", &n, &m, &q);
  for (int i = 0; i < n; ++i)
    scanf("%s", a[i]);

  for (int i = 0; i < q; ++i) {
    int sx, sy, tx, ty;
    scanf("%d %d %d %d", &sx, &sy, &tx, &ty);
    --sx, --sy, --tx, --ty;

    bfs(sx, sy, ds);
    bfs(tx, ty, dt);
    
    int D = ds[tx][ty];

    for (int j = 0; j <= D; ++j)
      cnt[j] = 0;

    for (int x = 0; x < n; ++x)
      for (int y = 0; y < m; ++y)
        if (ds[x][y] + dt[x][y] == D) cnt[ ds[x][y] ]++;

    for (int j = 1; j < D; ++j)
      if (cnt[j] < 2) {
        D++;
        break;
      }

    printf("%d\n", D);
  }

  return 0;
}
